# ProofIn - WordPress AI Chat Plugin

A WordPress plugin that lets visitors ask AI assistants about your company. Provides a clean, branded interface with support for ChatGPT, Claude, Perplexity, and more.

## Features

- 🎨 Multiple customizable templates (Hero, Card, Split, Footer)
- 🤖 Support for multiple AI models (ChatGPT, Claude, Perplexity, Gemini, Meta AI)
- 📝 Dynamic section management with shortcodes
- 🎯 Easy-to-use admin interface
- 🔒 Secure with nonce verification and capability checks
- 📱 Fully responsive design

## Installation

1. Upload the plugin folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to ProofIn → Add New to create your first section

## Usage

### Creating a Section

1. Navigate to **ProofIn → Add New**
2. Configure your section:
   - Title (for admin reference)
   - Template style
   - Heading and description
   - AI prompt text
   - Colors and typography
   - Select AI models to display
3. Click **Save Section**
4. Copy the generated shortcode: `[proofin id="X"]`

### Using the Shortcode

Add the shortcode to any page or post:
```
[proofin id="1"]
```

Replace `1` with your section ID.

## Plugin Structure

```
proofin/
├── proofin.php              # Main plugin file
├── includes/                  # PHP classes
│   ├── class-plugin.php       # Main controller
│   ├── class-database.php     # Database handler
│   ├── admin/                 # Admin classes
│   └── frontend/              # Frontend classes
├── templates/                 # Template files
│   ├── admin/                 # Admin page templates
│   └── frontend/              # Frontend templates
└── assets/                    # CSS, JS, and icons
    ├── css/
    ├── js/
    └── icons/
```

## Requirements

- WordPress 5.9 or higher
- PHP 8.1 or higher

## Documentation

For detailed code structure and development documentation, see [CODE-STRUCTURE.md](CODE-STRUCTURE.md).

## License

GPL v2 or later

## Author

ProofIn - https://proofin.com
