<?php
/**
 * Admin Assets Handler Class
 *
 * @package ProofIn
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class ProofIn_Admin_Assets
 * Handles admin CSS and JS enqueuing
 */
class ProofIn_Admin_Assets
{
    /**
     * Constructor
     */
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    /**
     * Enqueue admin assets
     *
     * @param string $hook Current admin page hook
     */
    public function enqueue_assets($hook)
    {
        // Only load on plugin pages
        $plugin_pages = [
            'toplevel_page_proofin-sections',
            'proofin_page_proofin-add-new',
            'proofin_page_proofin-settings'
        ];

        if (!in_array($hook, $plugin_pages)) {
            return;
        }

        // Enqueue styles
        wp_enqueue_style(
            'proofin-admin-style',
            PROOFIN_ASSETS_URL . 'css/admin-style.css',
            [],
            PROOFIN_VERSION
        );

        // Enqueue scripts for sections pages
        if (in_array($hook, ['toplevel_page_proofin-sections', 'proofin_page_proofin-add-new'])) {
            // Enqueue WordPress media uploader
            wp_enqueue_media();

            wp_enqueue_script(
                'proofin-admin-script',
                PROOFIN_ASSETS_URL . 'js/admin-script.js',
                ['jquery'],
                PROOFIN_VERSION,
                true
            );

            // Localize script
            wp_localize_script('proofin-admin-script', 'proofin_admin', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('proofin_nonce'),
                'sections_url' => admin_url('admin.php?page=proofin-sections'),
                'assets_url' => PROOFIN_ASSETS_URL,
                'strings' => [
                    'confirmDelete' => __('Are you sure you want to delete this section?', 'proofin'),
                    'saveSuccess' => __('Section saved successfully!', 'proofin'),
                    'saveError' => __('Error saving section. Please try again.', 'proofin'),
                    'deleteSuccess' => __('Section deleted successfully!', 'proofin'),
                    'deleteError' => __('Error deleting section. Please try again.', 'proofin'),
                ]
            ]);
        }
    }
}
