<?php
/**
 * Plugin Name: Proofin
 * Plugin URI: https://proofin.com
 * Description: This plugin lets visitors ask AI about your company. Feels conversational and branded.
 * Version: 1.0.2
 * Requires at least: 5.9
 * Requires PHP: 8.1
 * Author: Rankersfly
 * Author URI: https://rankersfly.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: proofin
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('PROOFIN_VERSION', '1.0.2');
define('PROOFIN_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PROOFIN_PLUGIN_URL', plugin_dir_url(__FILE__));
define('PROOFIN_INCLUDES_DIR', PROOFIN_PLUGIN_DIR . 'includes/');
define('PROOFIN_TEMPLATES_DIR', PROOFIN_PLUGIN_DIR . 'templates/');
define('PROOFIN_ASSETS_URL', PROOFIN_PLUGIN_URL . 'assets/');

// Load main plugin class
require_once PROOFIN_INCLUDES_DIR . 'class-plugin.php';

// Register activation hook
register_activation_hook(__FILE__, ['ProofIn_Plugin', 'activate']);

// Initialize plugin
function proofin_init()
{
    return ProofIn_Plugin::get_instance();
}

// Start the plugin
add_action('plugins_loaded', 'proofin_init');
