<?php
/**
 * Add New Section Page - Modern Tabbed Interface with Live Preview
 * 
 * @package ProofIn
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Check if editing existing section
$proofin_section_id = isset($_GET['id']) ? absint($_GET['id']) : 0;
$proofin_is_edit = $proofin_section_id > 0;

// Get section data if editing
$proofin_section = [];
if ($proofin_is_edit) {
    global $wpdb;
    $proofin_table_name = $wpdb->prefix . 'proofin_sections';
    $proofin_section = $wpdb->get_row($wpdb->prepare("SELECT * FROM $proofin_table_name WHERE id = %d", $proofin_section_id), ARRAY_A);

    if (!$proofin_section) {
        wp_die(esc_html__('Section not found.', 'proofin'));
    }
}

// Set defaults
$proofin_defaults = [
    'title' => 'Proofin Section',
    'template' => 'hero',
    'section_heading' => 'Research Us Anywhere',
    'section_description' => 'Learn more about our product using your favorite assistants and communities.',
    'prompt_text' => 'Tell me about {site_name} and what makes them unique',
    'heading_font_size' => '2.5',
    'heading_font_weight' => '700',
    'subheading_font_size' => '1.2',
    'subheading_font_weight' => '400',
    'heading_color' => '#1e293b',
    'subheading_color' => '#64748b',
    'description_border_width' => '2',
    'description_border_radius' => '20',
    'description_border_color' => '#000000',
    'background_color' => '#f8fafc',
    'background_type' => 'color',
    'background_image' => '',
    'background_image_id' => '',
    'ai_models' => 'chatgpt,claude,perplexity,reddit',
    'device_display' => 'all'
];

$proofin_data = $proofin_is_edit ? wp_parse_args($proofin_section, $proofin_defaults) : $proofin_defaults;
$proofin_ai_models_array = !empty($proofin_data['ai_models']) ? explode(',', $proofin_data['ai_models']) : [];
?>

<div class="wrap proofin-admin-wrapper">
    <h1 class="wp-heading-inline">
        <?php echo esc_html($proofin_is_edit ? __('Edit Section', 'proofin') : __('Add New Section', 'proofin')); ?>
    </h1>
    <?php if ($proofin_is_edit): ?>
        <a href="<?php echo esc_url(admin_url('admin.php?page=proofin-add-new')); ?>" class="page-title-action">
            <?php esc_html_e('Add New', 'proofin'); ?>
        </a>
    <?php endif; ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=proofin-sections')); ?>" class="page-title-action">
        <?php esc_html_e('Back to All Sections', 'proofin'); ?>
    </a>
    <hr class="wp-header-end">

    <div class="proofin-editor-container">
        <!-- Left Side: Tabbed Form -->
        <div class="proofin-editor-form">
            <div class="proofin-tabs">
                <div class="proofin-tabs-nav">
                    <button class="proofin-tab-button active" data-tab="content">
                        <span class="dashicons dashicons-edit-large"></span>
                        <?php esc_html_e('Content', 'proofin'); ?>
                    </button>
                    <button class="proofin-tab-button" data-tab="design">
                        <span class="dashicons dashicons-art"></span>
                        <?php esc_html_e('Design', 'proofin'); ?>
                    </button>
                    <button class="proofin-tab-button" data-tab="settings">
                        <span class="dashicons dashicons-admin-generic"></span>
                        <?php esc_html_e('Settings', 'proofin'); ?>
                    </button>
                </div>

                <form id="proofin-section-form" class="proofin-tabs-content">
                    <input type="hidden" id="section-id" value="<?php echo esc_attr($proofin_section_id); ?>">

                    <!-- Tab 1: Contents -->
                    <div class="proofin-tab-panel active" data-panel="content">
                        <div class="proofin-form-group">
                            <label for="section-heading">
                                <?php esc_html_e('Section Heading', 'proofin'); ?>
                                <span class="required">*</span>
                            </label>
                            <input type="text" id="section-heading" name="sectionHeading"
                                value="<?php echo esc_attr($proofin_data['section_heading']); ?>" required>
                            <p class="description"><?php esc_html_e('Create a catchy heading that clearly defines the section\'s purpose and grabs attention', 'proofin'); ?></p>
                        </div>

                        <div class="proofin-form-group">
                            <label for="section-description">
                                <?php esc_html_e('Section Description', 'proofin'); ?>
                            </label>
                            <textarea id="section-description" name="sectionDescription"
                                rows="3"><?php echo esc_textarea($proofin_data['section_description']); ?></textarea>
                            <p class="description"><?php esc_html_e('Write a concise description highlighting the key insights users will gain about your brand', 'proofin'); ?>
                            </p>
                        </div>

                        <div class="proofin-form-group">
                            <label for="prompt-text">
                                <?php esc_html_e('Research Prompt Text', 'proofin'); ?>
                                <span class="required">*</span>
                            </label>
                            <textarea id="prompt-text" name="promptText" rows="4"
                                required><?php echo esc_textarea($proofin_data['prompt_text']); ?></textarea>
                            <p class="description">
                                <?php esc_html_e('Craft a prompt with your site name to guide users on what to research or ask across platforms', 'proofin'); ?>
                            </p>
                        </div>
                    </div>

                    <!-- Tab 2 : Design -->
                    <div class="proofin-tab-panel" data-panel="design">
                            <div class="proofin-design-grid">
                                <!-- Template Selection -->
                                <div class="proofin-form-group">
                                    <label><?php esc_html_e('Layout Template', 'proofin'); ?></label>
                                    <p class="description">
                                        <?php esc_html_e('Choose a display style for your section', 'proofin'); ?>
                                    </p>
                                    <div class="proofin-template-grid">
                                        <?php
                                        $proofin_templates = [
                                            'hero' => ['name' => 'Hero', 'desc' => 'Large centered'],
                                            'card' => ['name' => 'Card', 'desc' => 'Left Aligned Content'],
                                            'footer' => ['name' => 'Footer', 'desc' => 'Minimal compact'],
                                            'icons_only' => ['name' => 'Icons Only', 'desc' => 'Minimal horizontal']
                                        ];
                                        foreach ($proofin_templates as $proofin_key => $proofin_template):
                                            $proofin_checked = ($proofin_data['template'] === $proofin_key) ? 'checked' : '';
                                            ?>
                                            <label class="proofin-template-option">
                                                <input type="radio" name="template" value="<?php echo esc_attr($proofin_key); ?>"
                                                    <?php echo esc_attr($proofin_checked); ?>>
                                                <div class="template-card">
                                                    <span class="template-name"><?php echo esc_html($proofin_template['name']); ?></span>
                                                    <span class="template-desc"><?php echo esc_html($proofin_template['desc']); ?></span>
                                                </div>
                                            </label>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <div class="proofin-form-group">
                                    <label><?php esc_html_e('Heading Style', 'proofin'); ?></label>
                                    <div class="proofin-input-group">
                                        <div class="proofin-field">
                                            <label
                                                for="heading-font-size"><?php esc_html_e('Size (rem)', 'proofin'); ?></label>
                                            <input type="number" id="heading-font-size" name="headingFontSize"
                                                value="<?php echo esc_attr($proofin_data['heading_font_size']); ?>" step="0.1"
                                                min="1" max="10">
                                        </div>
                                        <div class="proofin-field">
                                            <label for="heading-font-weight"><?php esc_html_e('Weight', 'proofin'); ?></label>
                                            <select id="heading-font-weight" name="headingFontWeight">
                                                <?php
                                                $proofin_weights = ['300' => 'Light', '400' => 'Normal', '500' => 'Medium', '600' => 'Semi-Bold', '700' => 'Bold', '800' => 'Extra Bold'];
                                                foreach ($proofin_weights as $proofin_value => $proofin_label):
                                                    ?>
                                                    <option value="<?php echo esc_attr($proofin_value); ?>" <?php selected($proofin_data['heading_font_weight'], $proofin_value); ?>>
                                                        <?php echo esc_html($proofin_label); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="proofin-field">
                                            <label for="heading-color"><?php esc_html_e('Color', 'proofin'); ?></label>
                                            <input type="color" id="heading-color" name="headingColor"
                                                value="<?php echo esc_attr($proofin_data['heading_color']); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="proofin-form-group">
                                    <label><?php esc_html_e('Description Style', 'proofin'); ?></label>
                                    <div class="proofin-input-group">
                                        <div class="proofin-field">
                                            <label
                                                for="subheading-font-size"><?php esc_html_e('Size (rem)', 'proofin'); ?></label>
                                            <input type="number" id="subheading-font-size" name="subheadingFontSize"
                                                value="<?php echo esc_attr($proofin_data['subheading_font_size']); ?>"
                                                step="0.1" min="0.5" max="5">
                                        </div>
                                        <div class="proofin-field">
                                            <label
                                                for="subheading-font-weight"><?php esc_html_e('Weight', 'proofin'); ?></label>
                                            <select id="subheading-font-weight" name="subheadingFontWeight">
                                                <?php foreach ($proofin_weights as $proofin_value => $proofin_label): ?>
                                                    <option value="<?php echo esc_attr($proofin_value); ?>" <?php selected($proofin_data['subheading_font_weight'], $proofin_value); ?>>
                                                        <?php echo esc_html($proofin_label); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="proofin-field">
                                            <label for="subheading-color"><?php esc_html_e('Color', 'proofin'); ?></label>
                                            <input type="color" id="subheading-color" name="subheadingColor"
                                                value="<?php echo esc_attr($proofin_data['subheading_color']); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="proofin-form-group">
                                    <label><?php esc_html_e('Section Border', 'proofin'); ?></label>
                                    <div class="proofin-input-group">
                                        <div class="proofin-field">
                                            <label for="description-border-width"><?php esc_html_e('Border Width (px)', 'proofin'); ?></label>
                                            <input type="number" id="description-border-width" name="descriptionBorderWidth"
                                                value="<?php echo esc_attr($proofin_data['description_border_width']); ?>"
                                                step="1" min="0" max="50">
                                        </div>
                                        <div class="proofin-field">
                                            <label for="description-border-radius"><?php esc_html_e('Border Radius (px)', 'proofin'); ?></label>
                                            <input type="number" id="description-border-radius" name="descriptionBorderRadius"
                                                value="<?php echo esc_attr($proofin_data['description_border_radius']); ?>"
                                                step="1" min="0" max="100">
                                        </div>
                                        <div class="proofin-field">
                                            <label for="description-border-color"><?php esc_html_e('Border Color', 'proofin'); ?></label>
                                            <input type="color" id="description-border-color" name="descriptionBorderColor"
                                                value="<?php echo esc_attr($proofin_data['description_border_color']); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="proofin-form-group">
                                    <label><?php esc_html_e('Background Style', 'proofin'); ?></label>
                                    <div class="proofin-input-group">
                                        <div class="proofin-field">
                                            <label for="background-type"><?php esc_html_e('Type', 'proofin'); ?></label>
                                            <select id="background-type" name="backgroundType">
                                                <option value="color" <?php selected($proofin_data['background_type'], 'color'); ?>><?php esc_html_e('Solid Color', 'proofin'); ?></option>
                                                <option value="image" <?php selected($proofin_data['background_type'], 'image'); ?>><?php esc_html_e('Image', 'proofin'); ?></option>
                                            </select>
                                        </div>
                                        
                                        <div class="proofin-field" id="background-color-field">
                                            <label for="background-color"><?php esc_html_e('Color', 'proofin'); ?></label>
                                            <input type="color" id="background-color" name="backgroundColor"
                                                value="<?php echo esc_attr($proofin_data['background_color']); ?>">
                                        </div>
                                        
                                        <div class="proofin-field" id="background-image-field" style="display:none;">
                                            <label for="background-image"><?php esc_html_e('Upload Image', 'proofin'); ?></label>
                                            <input type="hidden" id="background-image" name="backgroundImage"
                                                value="<?php echo esc_attr($proofin_data['background_image']); ?>">
                                            <input type="hidden" id="background-image-id" name="backgroundImageId"
                                                value="<?php echo esc_attr(!empty($proofin_data['background_image_id']) ? $proofin_data['background_image_id'] : ''); ?>">
                                            <button type="button" class="button button-secondary proofin-upload-image-btn" style="width: 100%; display: flex; align-items: center; justify-content: center; gap: 5px; font-weight: 600;">
                                                <span class="dashicons dashicons-upload"></span>
                                                <?php esc_html_e('Choose Image', 'proofin'); ?>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <!-- Image Preview (appears below when image is selected) -->
                                    <div id="background-image-preview-container" style="display: <?php echo esc_attr(!empty($proofin_data['background_image']) ? 'block' : 'none'); ?>; margin-top: 15px;">
                                        <div id="background-image-preview" class="proofin-image-preview">
                                            <?php if (!empty($proofin_data['background_image'])): ?>
                                                <img src="<?php echo esc_url($proofin_data['background_image']); ?>" alt="Background">
                                                <button type="button" class="proofin-remove-image">
                                                    <img src="<?php echo esc_url(plugins_url('assets/icons/cross.svg', dirname(dirname(__FILE__)))); ?>" alt="Remove">
                                                </button>
                                            <?php else: ?>
                                                <div class="proofin-image-placeholder">
                                                    <span class="dashicons dashicons-format-image"></span>
                                                    <p><?php esc_html_e('No image selected', 'proofin'); ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Tab 3: Settings -->
                        <div class="proofin-tab-panel" data-panel="settings">
                            <div class="proofin-form-group">
                                <label for="section-title">
                                    <?php esc_html_e('Section Name', 'proofin'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input type="text" id="section-title" name="title"
                                    value="<?php echo esc_attr($proofin_data['title']); ?>"
                                    placeholder="<?php esc_html_e('E.g., Homepage Hero Section', 'proofin'); ?>" required>
                                <p class="description">
                                    <?php esc_html_e('Internal name for this section (not shown to visitors)', 'proofin'); ?>
                                </p>
                            </div>

                            <div class="proofin-form-group device-setting-group">
                                <label><?php esc_html_e('Device Display', 'proofin'); ?></label>
                                <p class="description">
                                    <?php esc_html_e('Select where this section will be displayed: all devices, desktop, or mobile', 'proofin'); ?>
                                </p>
                                <div class="proofin-device-display-buttons">
                                    <label class="proofin-device-button">
                                        <input type="radio" name="deviceDisplay" value="all" <?php checked($proofin_data['device_display'], 'all'); ?>>
                                        <span class="device-button-label">
                                            <?php esc_html_e('All Devices', 'proofin'); ?>
                                        </span>
                                    </label>
                                    <label class="proofin-device-button">
                                        <input type="radio" name="deviceDisplay" value="desktop" <?php checked($proofin_data['device_display'], 'desktop'); ?>>
                                        <span class="device-button-label">
                                            <?php esc_html_e('Desktop Only', 'proofin'); ?>
                                        </span>
                                    </label>
                                    <label class="proofin-device-button">
                                        <input type="radio" name="deviceDisplay" value="mobile" <?php checked($proofin_data['device_display'], 'mobile'); ?>>
                                        <span class="device-button-label">
                                            <?php esc_html_e('Mobile Only', 'proofin'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>

                            <div class="proofin-form-group">
                                <label><?php esc_html_e('Select Tools to Show', 'proofin'); ?></label>
                                <p class="description">
                                    <?php esc_html_e('Choose which AI assistants to display', 'proofin'); ?>
                                </p>
                                <div class="proofin-ai-models-grid">
                                    <?php
                                    $proofin_models = [
                                        'chatgpt' => ['name' => 'ChatGPT', 'color' => '#10a37f'],
                                        'claude' => ['name' => 'Claude', 'color' => '#cc785c'],
                                        'perplexity' => ['name' => 'Perplexity', 'color' => '#20808d'],
                                        'reddit' => ['name' => 'Reddit', 'color' => '#ff4500'],
                                    ];
                                    foreach ($proofin_models as $proofin_key => $proofin_model):
                                        $proofin_checked = in_array($proofin_key, $proofin_ai_models_array) ? 'checked' : '';
                                        ?>
                                        <label class="proofin-ai-model-option">
                                            <input type="checkbox" name="aiModels[]" value="<?php echo esc_attr($proofin_key); ?>"
                                                <?php echo esc_attr($proofin_checked); ?>>
                                            <div class="ai-model-card"
                                                style="--model-color: <?php echo esc_attr($proofin_model['color']); ?>">
                                                <span class="ai-model-name"><?php echo esc_html($proofin_model['name']); ?></span>
                                            </div>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <div class="proofin-form-actions">
                            <button type="submit" class="button button-primary button-large">
                                <span class="dashicons dashicons-yes"></span>
                                <?php echo esc_html($proofin_is_edit ? __('Update', 'proofin') : __('Publish Section', 'proofin')); ?>
                            </button>
                            <?php if ($proofin_is_edit): ?>
                                <button type="button" class="button button-secondary"
                                    onclick="window.location.href='<?php echo esc_js(esc_url(admin_url('admin.php?page=proofin-add-new'))); ?>'">
                                    <?php esc_html_e('Create New Instead', 'proofin'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                </form>
            </div>
        </div>

        <!-- Right Side: Live Preview -->
        <div class="proofin-editor-preview">
            <div class="proofin-preview-header">
                <h3>
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('Live Preview', 'proofin'); ?>
                </h3>
                <div class="proofin-preview-device-toggle">
                    <button class="preview-device-btn active" data-device="desktop">
                        <span class="dashicons dashicons-desktop"></span>
                    </button>
                    <button class="preview-device-btn" data-device="mobile">
                        <span class="dashicons dashicons-smartphone"></span>
                    </button>
                </div>
            </div>
            <div class="proofin-preview-frame desktop">
                <div id="proofin-live-preview" class="proofin-preview-content">
                    <!-- Live preview will be rendered here by JavaScript -->
                </div>
            </div>
        </div>
    </div>

    <!-- Success Popup Modal (Forminator Style) -->
    <div id="proofin-success-modal" class="proofin-modal-overlay" style="display: none;">
        <div class="proofin-modal">
            <button type="button" class="proofin-modal-close">&times;</button>
            <div class="proofin-modal-content">
                <div class="proofin-modal-icon">
                    <span class="dashicons dashicons-yes-alt"></span>
                </div>
                <h2 class="proofin-modal-title">Ready to go!</h2>
                <p class="proofin-modal-description">
                    Your section is now ready to be embedded into a page or post of your choice. Simply copy and paste the shortcode below to display it!
                </p>
                <div class="proofin-modal-field">
                    <label>Shortcode</label>
                    <div class="proofin-shortcode-wrapper">
                        <input type="text" id="proofin-shortcode-input" class="proofin-shortcode-input" readonly value="">
                        <button type="button" class="proofin-copy-button" title="Copy to clipboard">
                            <span class="dashicons dashicons-admin-page"></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>