<?php
/**
 * ProofIn Uninstaller
 *
 * Fired when the plugin is uninstalled.
 * This file removes all plugin data from the database.
 *
 * @package ProofIn
 * @link    https://proofin.com
 * @since   1.0.0
 */

// Exit if accessed directly or not uninstalling
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete plugin database tables
 */
function proofin_delete_tables()
{
    global $wpdb;

    $table_name = $wpdb->prefix . 'proofin_sections';

    // Drop the table
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for uninstall cleanup, no caching needed for deletion
    $wpdb->query("DROP TABLE IF EXISTS {$table_name}");
}

/**
 * Delete plugin options
 */
function proofin_delete_options()
{
    // Delete any stored options (add if you create settings page)
    delete_option('proofin_version');
    delete_option('proofin_settings');

    // Delete transients
    global $wpdb;

    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for uninstall cleanup, no caching needed for deletion
    $wpdb->query(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_proofin_%' OR option_name LIKE '_transient_timeout_proofin_%'"
    );
}

/**
 * Delete plugin user meta
 */
function proofin_delete_user_meta()
{
    global $wpdb;

    // Delete any user meta created by plugin
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for uninstall cleanup, no caching needed for deletion
    $wpdb->query(
        "DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'proofin_%'"
    );
}

/**
 * Only delete data if user wants it
 * To keep data on uninstall, add: define('PROOFIN_KEEP_DATA', true); to wp-config.php
 */
if (!defined('PROOFIN_KEEP_DATA') || PROOFIN_KEEP_DATA !== true) {
    proofin_delete_tables();
    proofin_delete_options();
    proofin_delete_user_meta();
}

// Clear any cached data
wp_cache_flush();
